#==============================================================================
#  Markup_Text_Module
#------------------------------------------------------------------------------
# }[NAbveLXgW[
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# ̃W[gꍇ́A
# String_Replace_ModuleStringOperation_Module邱
# BitmapWindowSpriteincludełi\j
#
#==============================================================================

module Markup_Text_Module
  attr_accessor :line_height
  # ϊ`eLXgTCY
  def markup_text_size(test_text,bmp=nil)
    if @line_height.nil?
      if defined? Markup_New_Line
        @line_height = Markup_New_Line.line_height
      else
        @line_height = Font.default_size
      end
    end
    tmp_dispose = false
    if bmp.nil?
      bmp = Bitmap.new(640,128)
      tmp_dispose = true
    end
    (x,y) = 0,0
    rect = Rect.new(0,0,0,0)
    text = markup_replace(test_text)
    text.split(/\n/).each do |line|
      while line.size != 0
        x,y,line = markup_operation(x,y,line,bmp)
        c = line.slice!(/./m)
        if c.nil?
          break
        end
        w = bmp.text_size(c).width
        # s
        if bmp.rect.width < (x + w)
          x = 0
          y += @line_height
          rect.height = [y,rect.height].max
        end
        x += w
        rect.width = [x,rect.width].max
      end
      x = 0
      y += @line_height
      rect.height = [y,rect.height].max
    end
    if tmp_dispose
      bmp.dispose()
    end
    return rect
  end

  # ϊ`
  def draw_markup_text(*arg)
    if @line_height.nil?
      if defined? Markup_New_Line
        @line_height = Markup_New_Line.line_height
      else
        @line_height = Font.default_size
      end
    end
    case self
    when Bitmap
      bmp = self
    when Window
      bmp = self.contents
    when Sprite
      bmp = self.bitmap
    else
      return
    end
    case arg.size
    when 1
      if arg[0].is_a?(String)
        src_text = arg[0]
        (x,y) = 0,0
      end
    when 3
      if arg[0].is_a?(Fixnum) and arg[1].is_a?(Fixnum)
        (x,y) = arg[0],arg[1]
      end
      if arg[2].is_a?(String)
        src_text = arg[2]
      end
    end
    text = markup_replace(src_text)
    text.split(/\n/).each do |line|
      while line.size != 0
        x,y,line = markup_operation(x,y,line,bmp)
        c = line.slice!(/./m)
        if c.nil?
          break
        end
        w = bmp.text_size(c).width
        # s
        if bmp.rect.width < (x + w)
          x = 0
          y += @line_height
        end
        bmp.draw_text(x,y,w,@line_height,c)
        x += w
      end
      x = 0
      y += @line_height
    end
  end

end
